/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.code.instruction.base;

import at.pollaknet.api.facile.code.instruction.CilInstruction;
import at.pollaknet.api.facile.exception.InvalidByteCodeException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.util.ByteReader;

public class Ldloca
extends CilInstruction {
    public static final byte SECOND_TOKEN = 13;
    public static final byte BYTE_SIZE = 3;
    private int address;

    @Override
    public String render(LanguageRenderer renderer) {
        return this.toString();
    }

    @Override
    public int parseInstruction(byte[] buffer, int index, MetadataModel metaModel) throws InvalidByteCodeException {
        Ldloca.ensure(buffer, index, (byte)-2);
        Ldloca.ensure(buffer, index + 1, (byte)13);
        this.address = ByteReader.getUInt16(buffer, index + 2);
        return 3;
    }

    public int getAddress() {
        return this.address;
    }

    public String toString() {
        return "ldloca " + this.address;
    }

    @Override
    public byte getByteSize() {
        return 3;
    }

    @Override
    public byte getFirstToken() {
        return -2;
    }

    @Override
    public byte getSecondToken() {
        return 13;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((Ldloca)obj).address == this.address;
    }

    @Override
    public int hashCode() {
        return 751 + this.address;
    }
}

