/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.code.instruction.base;

import at.pollaknet.api.facile.code.instruction.CilInstruction;
import at.pollaknet.api.facile.exception.InvalidByteCodeException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.util.ByteReader;

public class Ldloc
extends CilInstruction {
    public static final byte SECOND_TOKEN = 12;
    public static final byte BYTE_SIZE = 3;
    private int index;

    @Override
    public String render(LanguageRenderer renderer) {
        return this.toString();
    }

    @Override
    public int parseInstruction(byte[] buffer, int index, MetadataModel metaModel) throws InvalidByteCodeException {
        Ldloc.ensure(buffer, index, (byte)-2);
        Ldloc.ensure(buffer, index + 1, (byte)12);
        this.index = ByteReader.getUInt16(buffer, index + 2);
        return 3;
    }

    public int getLocalVarIndex() {
        return this.index;
    }

    public String toString() {
        return "ldloc " + this.index;
    }

    @Override
    public byte getByteSize() {
        return 3;
    }

    @Override
    public byte getFirstToken() {
        return -2;
    }

    @Override
    public byte getSecondToken() {
        return 12;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((Ldloc)obj).index == this.index;
    }

    @Override
    public int hashCode() {
        return 719 + this.index;
    }
}

