/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.code.instruction.base;

import at.pollaknet.api.facile.code.instruction.CilInstruction;
import at.pollaknet.api.facile.exception.InvalidByteCodeException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.util.ByteReader;

public class LdcR8
extends CilInstruction {
    public static final byte FIRST_TOKEN = 35;
    public static final byte BYTE_SIZE = 9;
    private double constant;

    @Override
    public String render(LanguageRenderer renderer) {
        return this.toString();
    }

    @Override
    public int parseInstruction(byte[] buffer, int index, MetadataModel metaModel) throws InvalidByteCodeException {
        LdcR8.ensure(buffer, index, (byte)35);
        this.constant = ByteReader.getDouble(buffer, index + 1);
        return 9;
    }

    public double getConstant() {
        return this.constant;
    }

    public String toString() {
        return "ldc.r8 " + this.constant;
    }

    @Override
    public byte getByteSize() {
        return 9;
    }

    @Override
    public byte getFirstToken() {
        return 35;
    }

    @Override
    public byte getSecondToken() {
        return -2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (Double.isNaN(((LdcR8)obj).constant)) {
            return Double.isNaN(this.constant);
        }
        return ((LdcR8)obj).constant == this.constant;
    }

    @Override
    public int hashCode() {
        long raw = Double.doubleToLongBits(this.constant);
        return 631 + (int)(raw ^ raw >>> 32);
    }
}

