/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.code.instruction.base;

import at.pollaknet.api.facile.code.instruction.CilInstruction;
import at.pollaknet.api.facile.exception.InvalidByteCodeException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.util.ByteReader;

public class LdcI8
extends CilInstruction {
    public static final byte FIRST_TOKEN = 33;
    public static final byte BYTE_SIZE = 9;
    private long constant;

    @Override
    public String render(LanguageRenderer renderer) {
        return this.toString();
    }

    @Override
    public int parseInstruction(byte[] buffer, int index, MetadataModel metaModel) throws InvalidByteCodeException {
        LdcI8.ensure(buffer, index, (byte)33);
        this.constant = ByteReader.getInt64(buffer, index + 1);
        return 9;
    }

    public long getConstant() {
        return this.constant;
    }

    public String toString() {
        return "ldc.i8 " + this.constant;
    }

    @Override
    public byte getByteSize() {
        return 9;
    }

    @Override
    public byte getFirstToken() {
        return 33;
    }

    @Override
    public byte getSecondToken() {
        return -2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((LdcI8)obj).constant == this.constant;
    }

    @Override
    public int hashCode() {
        return 617 + (int)(this.constant ^ this.constant >>> 32);
    }
}

