/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.code.instruction.base;

import at.pollaknet.api.facile.code.instruction.CilInstruction;
import at.pollaknet.api.facile.exception.InvalidByteCodeException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.util.ByteReader;

public class LdcI4
extends CilInstruction {
    public static final byte FIRST_TOKEN = 32;
    public static final byte BYTE_SIZE = 5;
    private int constant;

    @Override
    public String render(LanguageRenderer renderer) {
        return this.toString();
    }

    @Override
    public int parseInstruction(byte[] buffer, int index, MetadataModel metaModel) throws InvalidByteCodeException {
        LdcI4.ensure(buffer, index, (byte)32);
        this.constant = ByteReader.getInt32(buffer, index + 1);
        return 5;
    }

    public int getConstant() {
        return this.constant;
    }

    public String toString() {
        return "ldc.i4 " + this.constant;
    }

    @Override
    public byte getByteSize() {
        return 5;
    }

    @Override
    public byte getFirstToken() {
        return 32;
    }

    @Override
    public byte getSecondToken() {
        return -2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((LdcI4)obj).constant == this.constant;
    }

    @Override
    public int hashCode() {
        return 547 + this.constant;
    }
}

