/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.code.instruction.base;

import at.pollaknet.api.facile.code.instruction.CilInstruction;
import at.pollaknet.api.facile.exception.InvalidByteCodeException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.util.ByteReader;

public class Ldarg
extends CilInstruction {
    public static final byte SECOND_TOKEN = 9;
    public static final byte BYTE_SIZE = 3;
    private int argumentNumber;

    @Override
    public String render(LanguageRenderer renderer) {
        return this.toString();
    }

    @Override
    public int parseInstruction(byte[] buffer, int index, MetadataModel metaModel) throws InvalidByteCodeException {
        Ldarg.ensure(buffer, index, (byte)-2);
        Ldarg.ensure(buffer, index + 1, (byte)9);
        this.argumentNumber = ByteReader.getUInt16(buffer, index + 2);
        return 3;
    }

    public int getArgumentNumber() {
        return this.argumentNumber;
    }

    public String toString() {
        return "ldarg " + this.argumentNumber;
    }

    @Override
    public byte getByteSize() {
        return 3;
    }

    @Override
    public byte getFirstToken() {
        return -2;
    }

    @Override
    public byte getSecondToken() {
        return 9;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((Ldarg)obj).argumentNumber == this.argumentNumber;
    }

    @Override
    public int hashCode() {
        return 487 + this.argumentNumber;
    }
}

