/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.code.instruction.base;

import at.pollaknet.api.facile.code.instruction.TargetCilInstruction;
import at.pollaknet.api.facile.exception.InvalidByteCodeException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.renderer.ILAsmRenderer;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.util.ByteReader;

public class BgtS
extends TargetCilInstruction {
    public static final byte FIRST_TOKEN = 48;
    public static final byte BYTE_SIZE = 2;

    @Override
    public String render(LanguageRenderer renderer) {
        assert (renderer instanceof ILAsmRenderer);
        return "bgt.s " + ((ILAsmRenderer)renderer).renderRelativeAsLabel(this.target);
    }

    @Override
    public int parseInstruction(byte[] buffer, int index, MetadataModel metaModel) throws InvalidByteCodeException {
        BgtS.ensure(buffer, index, (byte)48);
        this.target = ByteReader.getInt8(buffer, index + 1);
        return 2;
    }

    public String toString() {
        return "bgt.s " + this.target;
    }

    @Override
    public byte getByteSize() {
        return 2;
    }

    @Override
    public byte getFirstToken() {
        return 48;
    }

    @Override
    public byte getSecondToken() {
        return -2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((BgtS)obj).target == this.target;
    }

    @Override
    public int hashCode() {
        return 89 + this.target;
    }
}

