/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.code;

import at.pollaknet.api.facile.code.CilContainer;
import at.pollaknet.api.facile.code.ExceptionClause;
import at.pollaknet.api.facile.code.instruction.CilInstruction;
import at.pollaknet.api.facile.code.instruction.base.Add;
import at.pollaknet.api.facile.code.instruction.base.AddOvf;
import at.pollaknet.api.facile.code.instruction.base.AddOvfUn;
import at.pollaknet.api.facile.code.instruction.base.And;
import at.pollaknet.api.facile.code.instruction.base.ArgList;
import at.pollaknet.api.facile.code.instruction.base.Beq;
import at.pollaknet.api.facile.code.instruction.base.BeqS;
import at.pollaknet.api.facile.code.instruction.base.Bge;
import at.pollaknet.api.facile.code.instruction.base.BgeS;
import at.pollaknet.api.facile.code.instruction.base.BgeUn;
import at.pollaknet.api.facile.code.instruction.base.BgeUnS;
import at.pollaknet.api.facile.code.instruction.base.Bgt;
import at.pollaknet.api.facile.code.instruction.base.BgtS;
import at.pollaknet.api.facile.code.instruction.base.BgtUn;
import at.pollaknet.api.facile.code.instruction.base.BgtUnS;
import at.pollaknet.api.facile.code.instruction.base.Ble;
import at.pollaknet.api.facile.code.instruction.base.BleS;
import at.pollaknet.api.facile.code.instruction.base.BleUn;
import at.pollaknet.api.facile.code.instruction.base.BleUnS;
import at.pollaknet.api.facile.code.instruction.base.Blt;
import at.pollaknet.api.facile.code.instruction.base.BltS;
import at.pollaknet.api.facile.code.instruction.base.BltUn;
import at.pollaknet.api.facile.code.instruction.base.BltUnS;
import at.pollaknet.api.facile.code.instruction.base.BneUn;
import at.pollaknet.api.facile.code.instruction.base.BneUnS;
import at.pollaknet.api.facile.code.instruction.base.Br;
import at.pollaknet.api.facile.code.instruction.base.BrS;
import at.pollaknet.api.facile.code.instruction.base.Break;
import at.pollaknet.api.facile.code.instruction.base.Brfalse;
import at.pollaknet.api.facile.code.instruction.base.BrfalseS;
import at.pollaknet.api.facile.code.instruction.base.Brtrue;
import at.pollaknet.api.facile.code.instruction.base.BrtrueS;
import at.pollaknet.api.facile.code.instruction.base.Call;
import at.pollaknet.api.facile.code.instruction.base.Calli;
import at.pollaknet.api.facile.code.instruction.base.Ceq;
import at.pollaknet.api.facile.code.instruction.base.Cgt;
import at.pollaknet.api.facile.code.instruction.base.CgtUn;
import at.pollaknet.api.facile.code.instruction.base.Ckfinite;
import at.pollaknet.api.facile.code.instruction.base.Clt;
import at.pollaknet.api.facile.code.instruction.base.CltUn;
import at.pollaknet.api.facile.code.instruction.base.ConvI;
import at.pollaknet.api.facile.code.instruction.base.ConvI1;
import at.pollaknet.api.facile.code.instruction.base.ConvI2;
import at.pollaknet.api.facile.code.instruction.base.ConvI4;
import at.pollaknet.api.facile.code.instruction.base.ConvI8;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfI;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfI1;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfI1Un;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfI2;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfI2Un;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfI4;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfI4Un;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfI8;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfI8Un;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfIUn;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfU;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfU1;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfU1Un;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfU2;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfU2Un;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfU4;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfU4Un;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfU8;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfU8Un;
import at.pollaknet.api.facile.code.instruction.base.ConvOvfUUn;
import at.pollaknet.api.facile.code.instruction.base.ConvR4;
import at.pollaknet.api.facile.code.instruction.base.ConvR8;
import at.pollaknet.api.facile.code.instruction.base.ConvRUn;
import at.pollaknet.api.facile.code.instruction.base.ConvU;
import at.pollaknet.api.facile.code.instruction.base.ConvU1;
import at.pollaknet.api.facile.code.instruction.base.ConvU2;
import at.pollaknet.api.facile.code.instruction.base.ConvU4;
import at.pollaknet.api.facile.code.instruction.base.ConvU8;
import at.pollaknet.api.facile.code.instruction.base.Cpblk;
import at.pollaknet.api.facile.code.instruction.base.Div;
import at.pollaknet.api.facile.code.instruction.base.DivUn;
import at.pollaknet.api.facile.code.instruction.base.Dup;
import at.pollaknet.api.facile.code.instruction.base.Endfilter;
import at.pollaknet.api.facile.code.instruction.base.Endfinally;
import at.pollaknet.api.facile.code.instruction.base.Initblk;
import at.pollaknet.api.facile.code.instruction.base.Jmp;
import at.pollaknet.api.facile.code.instruction.base.Ldarg;
import at.pollaknet.api.facile.code.instruction.base.Ldarg0;
import at.pollaknet.api.facile.code.instruction.base.Ldarg1;
import at.pollaknet.api.facile.code.instruction.base.Ldarg2;
import at.pollaknet.api.facile.code.instruction.base.Ldarg3;
import at.pollaknet.api.facile.code.instruction.base.LdargS;
import at.pollaknet.api.facile.code.instruction.base.Ldarga;
import at.pollaknet.api.facile.code.instruction.base.LdargaS;
import at.pollaknet.api.facile.code.instruction.base.LdcI4;
import at.pollaknet.api.facile.code.instruction.base.LdcI40;
import at.pollaknet.api.facile.code.instruction.base.LdcI41;
import at.pollaknet.api.facile.code.instruction.base.LdcI42;
import at.pollaknet.api.facile.code.instruction.base.LdcI43;
import at.pollaknet.api.facile.code.instruction.base.LdcI44;
import at.pollaknet.api.facile.code.instruction.base.LdcI45;
import at.pollaknet.api.facile.code.instruction.base.LdcI46;
import at.pollaknet.api.facile.code.instruction.base.LdcI47;
import at.pollaknet.api.facile.code.instruction.base.LdcI48;
import at.pollaknet.api.facile.code.instruction.base.LdcI4M1;
import at.pollaknet.api.facile.code.instruction.base.LdcI4S;
import at.pollaknet.api.facile.code.instruction.base.LdcI8;
import at.pollaknet.api.facile.code.instruction.base.LdcR4;
import at.pollaknet.api.facile.code.instruction.base.LdcR8;
import at.pollaknet.api.facile.code.instruction.base.Ldftn;
import at.pollaknet.api.facile.code.instruction.base.LdindI;
import at.pollaknet.api.facile.code.instruction.base.LdindI1;
import at.pollaknet.api.facile.code.instruction.base.LdindI2;
import at.pollaknet.api.facile.code.instruction.base.LdindI4;
import at.pollaknet.api.facile.code.instruction.base.LdindI8;
import at.pollaknet.api.facile.code.instruction.base.LdindR4;
import at.pollaknet.api.facile.code.instruction.base.LdindR8;
import at.pollaknet.api.facile.code.instruction.base.LdindRef;
import at.pollaknet.api.facile.code.instruction.base.LdindU1;
import at.pollaknet.api.facile.code.instruction.base.LdindU2;
import at.pollaknet.api.facile.code.instruction.base.LdindU4;
import at.pollaknet.api.facile.code.instruction.base.Ldloc;
import at.pollaknet.api.facile.code.instruction.base.Ldloc0;
import at.pollaknet.api.facile.code.instruction.base.Ldloc1;
import at.pollaknet.api.facile.code.instruction.base.Ldloc2;
import at.pollaknet.api.facile.code.instruction.base.Ldloc3;
import at.pollaknet.api.facile.code.instruction.base.LdlocS;
import at.pollaknet.api.facile.code.instruction.base.Ldloca;
import at.pollaknet.api.facile.code.instruction.base.LdlocaS;
import at.pollaknet.api.facile.code.instruction.base.Ldnull;
import at.pollaknet.api.facile.code.instruction.base.Leave;
import at.pollaknet.api.facile.code.instruction.base.LeaveS;
import at.pollaknet.api.facile.code.instruction.base.Localloc;
import at.pollaknet.api.facile.code.instruction.base.Mul;
import at.pollaknet.api.facile.code.instruction.base.MulOvf;
import at.pollaknet.api.facile.code.instruction.base.MulOvfUn;
import at.pollaknet.api.facile.code.instruction.base.Neg;
import at.pollaknet.api.facile.code.instruction.base.Nop;
import at.pollaknet.api.facile.code.instruction.base.Not;
import at.pollaknet.api.facile.code.instruction.base.Or;
import at.pollaknet.api.facile.code.instruction.base.Pop;
import at.pollaknet.api.facile.code.instruction.base.Rem;
import at.pollaknet.api.facile.code.instruction.base.RemUn;
import at.pollaknet.api.facile.code.instruction.base.Ret;
import at.pollaknet.api.facile.code.instruction.base.Shl;
import at.pollaknet.api.facile.code.instruction.base.Shr;
import at.pollaknet.api.facile.code.instruction.base.ShrUn;
import at.pollaknet.api.facile.code.instruction.base.Starg;
import at.pollaknet.api.facile.code.instruction.base.StargS;
import at.pollaknet.api.facile.code.instruction.base.StindI;
import at.pollaknet.api.facile.code.instruction.base.StindI1;
import at.pollaknet.api.facile.code.instruction.base.StindI2;
import at.pollaknet.api.facile.code.instruction.base.StindI4;
import at.pollaknet.api.facile.code.instruction.base.StindI8;
import at.pollaknet.api.facile.code.instruction.base.StindR4;
import at.pollaknet.api.facile.code.instruction.base.StindR8;
import at.pollaknet.api.facile.code.instruction.base.StindRef;
import at.pollaknet.api.facile.code.instruction.base.Stloc;
import at.pollaknet.api.facile.code.instruction.base.Stloc0;
import at.pollaknet.api.facile.code.instruction.base.Stloc1;
import at.pollaknet.api.facile.code.instruction.base.Stloc2;
import at.pollaknet.api.facile.code.instruction.base.Stloc3;
import at.pollaknet.api.facile.code.instruction.base.StlocS;
import at.pollaknet.api.facile.code.instruction.base.Sub;
import at.pollaknet.api.facile.code.instruction.base.SubOvf;
import at.pollaknet.api.facile.code.instruction.base.SubOvfUn;
import at.pollaknet.api.facile.code.instruction.base.Switch;
import at.pollaknet.api.facile.code.instruction.base.Xor;
import at.pollaknet.api.facile.code.instruction.object.Box;
import at.pollaknet.api.facile.code.instruction.object.Callvirt;
import at.pollaknet.api.facile.code.instruction.object.Castclass;
import at.pollaknet.api.facile.code.instruction.object.Cpobj;
import at.pollaknet.api.facile.code.instruction.object.Initobj;
import at.pollaknet.api.facile.code.instruction.object.Isinst;
import at.pollaknet.api.facile.code.instruction.object.Ldelem;
import at.pollaknet.api.facile.code.instruction.object.LdelemI;
import at.pollaknet.api.facile.code.instruction.object.LdelemI1;
import at.pollaknet.api.facile.code.instruction.object.LdelemI2;
import at.pollaknet.api.facile.code.instruction.object.LdelemI4;
import at.pollaknet.api.facile.code.instruction.object.LdelemI8;
import at.pollaknet.api.facile.code.instruction.object.LdelemR4;
import at.pollaknet.api.facile.code.instruction.object.LdelemR8;
import at.pollaknet.api.facile.code.instruction.object.LdelemRef;
import at.pollaknet.api.facile.code.instruction.object.LdelemU1;
import at.pollaknet.api.facile.code.instruction.object.LdelemU2;
import at.pollaknet.api.facile.code.instruction.object.LdelemU4;
import at.pollaknet.api.facile.code.instruction.object.Ldelema;
import at.pollaknet.api.facile.code.instruction.object.Ldfld;
import at.pollaknet.api.facile.code.instruction.object.Ldflda;
import at.pollaknet.api.facile.code.instruction.object.Ldlen;
import at.pollaknet.api.facile.code.instruction.object.Ldobj;
import at.pollaknet.api.facile.code.instruction.object.Ldsfld;
import at.pollaknet.api.facile.code.instruction.object.Ldsflda;
import at.pollaknet.api.facile.code.instruction.object.Ldstr;
import at.pollaknet.api.facile.code.instruction.object.Ldtoken;
import at.pollaknet.api.facile.code.instruction.object.Ldvirtftn;
import at.pollaknet.api.facile.code.instruction.object.Mkrefany;
import at.pollaknet.api.facile.code.instruction.object.Newarr;
import at.pollaknet.api.facile.code.instruction.object.Newobj;
import at.pollaknet.api.facile.code.instruction.object.Refanytype;
import at.pollaknet.api.facile.code.instruction.object.Refanyval;
import at.pollaknet.api.facile.code.instruction.object.Rethrow;
import at.pollaknet.api.facile.code.instruction.object.Sizeof;
import at.pollaknet.api.facile.code.instruction.object.Stelem;
import at.pollaknet.api.facile.code.instruction.object.StelemI;
import at.pollaknet.api.facile.code.instruction.object.StelemI1;
import at.pollaknet.api.facile.code.instruction.object.StelemI2;
import at.pollaknet.api.facile.code.instruction.object.StelemI4;
import at.pollaknet.api.facile.code.instruction.object.StelemI8;
import at.pollaknet.api.facile.code.instruction.object.StelemR4;
import at.pollaknet.api.facile.code.instruction.object.StelemR8;
import at.pollaknet.api.facile.code.instruction.object.StelemRef;
import at.pollaknet.api.facile.code.instruction.object.Stfld;
import at.pollaknet.api.facile.code.instruction.object.Stobj;
import at.pollaknet.api.facile.code.instruction.object.Stsfld;
import at.pollaknet.api.facile.code.instruction.object.Throw;
import at.pollaknet.api.facile.code.instruction.object.Unbox;
import at.pollaknet.api.facile.code.instruction.object.UnboxAny;
import at.pollaknet.api.facile.code.instruction.prefix.Constrained;
import at.pollaknet.api.facile.code.instruction.prefix.No;
import at.pollaknet.api.facile.code.instruction.prefix.ReadOnly;
import at.pollaknet.api.facile.code.instruction.prefix.Tail;
import at.pollaknet.api.facile.code.instruction.prefix.Unaligned;
import at.pollaknet.api.facile.code.instruction.prefix.Volatile;
import at.pollaknet.api.facile.exception.InvalidByteCodeException;
import at.pollaknet.api.facile.exception.InvalidMethodBodyException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.util.ByteReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class MethodBody {
    public static final int FLAGS_MORE_SECTIONS = 8;
    public static final int FLAGS_INIT_LOCAL = 16;
    private static final int SIGNATURE_TINY_METHOD = 2;
    private static final int SIGNATURE_FAT_METHOD = 3;
    private static final int SIGNATURE_BIT_MASK = 3;
    private static final int FLAGS_EXCEPTION_CLAUSE_MORE_SECTIONS = 128;
    private static final int FLAGS_EXCEPTION_CLAUSE_FAT = 64;
    private static final int SIZE_OF_EXTRA_DATA_HEADER = 4;
    private int flags = 0;
    private int headerSize = 0;
    private int maxStack = 8;
    private int codeSize = 0;
    private long localVarSignatureToken = 0L;
    private long methodToken = 0x6000000L;
    private CilInstruction[] cilInstructions;
    private TypeRef[] localVars;
    private ExceptionClause[] exceptionClauses;

    public MethodBody(int methodNumber) {
        this.flags = 2;
        this.methodToken += (long)methodNumber;
    }

    public MethodBody(MetadataModel metaModel, CilContainer container, long relativeVirtualAddress, int methodNumber) throws InvalidMethodBodyException {
        this.methodToken += (long)methodNumber;
        if (metaModel.isByteCodeNeed()) {
            int addressInByteBuffer = container.getPhysicalAddressOf(relativeVirtualAddress);
            this.extractBody(metaModel, container.getCodeBuffer(), addressInByteBuffer);
        }
    }

    private int extractBody(MetadataModel metaModel, byte[] data, int offset) throws InvalidMethodBodyException {
        if (offset < 0 || offset >= data.length) {
            throw new InvalidMethodBodyException(String.format("Virtual address %d is out of range [0,%d]", offset, data.length));
        }
        int byteCounter = offset;
        if (ByteReader.testFlags((int)data[byteCounter], 3, 3)) {
            byteCounter = this.processFatMethod(metaModel, data, byteCounter);
        } else if (ByteReader.testFlags((int)data[byteCounter], 3, 2)) {
            byteCounter = this.processTinyMethod(metaModel, data, byteCounter);
        } else {
            throw new InvalidMethodBodyException("Invalid method body");
        }
        return byteCounter - offset;
    }

    private int processFatMethod(MetadataModel metaModel, byte[] data, int byteCounter) throws InvalidMethodBodyException {
        this.flags = ByteReader.getUInt16(data, byteCounter);
        byteCounter += 2;
        this.headerSize = this.flags >> 10 & 0xFC;
        if (this.headerSize != 12) {
            throw new InvalidMethodBodyException("Size of Header is not allowed: " + this.headerSize + " (expected 12)");
        }
        this.flags &= 0xFFF;
        boolean moreSections = ByteReader.testFlags(this.flags, 8);
        this.maxStack = ByteReader.getUInt16(data, byteCounter);
        long size = ByteReader.getUInt32(data, byteCounter += 2);
        assert (size <= Integer.MAX_VALUE);
        this.codeSize = (int)size;
        this.localVarSignatureToken = ByteReader.getUInt32(data, byteCounter += 4);
        this.cilInstructions = MethodBody.createInstructionList(metaModel, data, byteCounter += 4, this.codeSize);
        assert (this.codeSize >= 0);
        byteCounter += this.codeSize;
        byteCounter += this.processExtraDataSections(metaModel, data, byteCounter, moreSections);
        return byteCounter;
    }

    private int processTinyMethod(MetadataModel metaModel, byte[] data, int byteCounter) throws InvalidMethodBodyException {
        this.flags = 2;
        this.codeSize = ByteReader.getUInt8(data, byteCounter) >> 2;
        ++byteCounter;
        if (this.codeSize > 63) {
            throw new InvalidMethodBodyException("Method body is too large for tiny header: " + this.codeSize + " (max. 63)");
        }
        this.cilInstructions = MethodBody.createInstructionList(metaModel, data, byteCounter, this.codeSize);
        assert (this.codeSize >= 0);
        return byteCounter += this.codeSize;
    }

    private int processExtraDataSections(MetadataModel metaModel, byte[] data, int offset, boolean moreSections) throws InvalidMethodBodyException {
        if (!moreSections) {
            return 0;
        }
        int byteCounter = offset;
        ArrayList<ExceptionClause> clauses = new ArrayList<ExceptionClause>();
        while (moreSections) {
            int numberOfClauses;
            int sectionSize;
            byteCounter = ByteReader.alignToDWord(byteCounter);
            short exceptionFlags = ByteReader.getUInt8(data, byteCounter);
            ++byteCounter;
            boolean fatClauses = ByteReader.testFlags(exceptionFlags, 64);
            moreSections = ByteReader.testFlags(exceptionFlags, 128);
            if (!fatClauses) {
                sectionSize = ByteReader.getUInt8(data, byteCounter);
                byteCounter += 3;
                numberOfClauses = (sectionSize - 4) / 12;
            } else {
                sectionSize = ByteReader.getUInt16(data, byteCounter);
                ++byteCounter;
                numberOfClauses = ((sectionSize += ByteReader.getUInt8(data, byteCounter += 2) << 16) - 4) / 24;
            }
            if ((exceptionFlags & 2) == 2) {
                byteCounter += sectionSize - 4;
                continue;
            }
            byteCounter = ByteReader.alignToDWord(byteCounter);
            for (int i = 0; i < numberOfClauses; ++i) {
                ExceptionClause clause = new ExceptionClause(fatClauses);
                byteCounter += clause.extract(metaModel, data, byteCounter);
                clauses.add(clause);
            }
        }
        int index = 0;
        this.exceptionClauses = new ExceptionClause[clauses.size()];
        Iterator iterator = clauses.iterator();
        while (iterator.hasNext()) {
            ExceptionClause clause;
            this.exceptionClauses[index] = clause = (ExceptionClause)iterator.next();
            ++index;
        }
        return byteCounter - offset;
    }

    private static CilInstruction[] createInstructionList(MetadataModel metaModel, byte[] data, int offset, int length) throws InvalidByteCodeException {
        if (length < 1) {
            return new CilInstruction[0];
        }
        ArrayList<Add> instructions = new ArrayList<Add>();
        CilInstruction currentInstruction = null;
        for (int index = offset; index < length + offset; index += ((CilInstruction)currentInstruction).parseInstruction(data, index, metaModel)) {
            switch (data[index]) {
                case 88: {
                    currentInstruction = new Add();
                    break;
                }
                case -42: {
                    currentInstruction = new AddOvf();
                    break;
                }
                case -41: {
                    currentInstruction = new AddOvfUn();
                    break;
                }
                case 95: {
                    currentInstruction = new And();
                    break;
                }
                case 59: {
                    currentInstruction = new Beq();
                    break;
                }
                case 46: {
                    currentInstruction = new BeqS();
                    break;
                }
                case 60: {
                    currentInstruction = new Bge();
                    break;
                }
                case 47: {
                    currentInstruction = new BgeS();
                    break;
                }
                case 65: {
                    currentInstruction = new BgeUn();
                    break;
                }
                case 52: {
                    currentInstruction = new BgeUnS();
                    break;
                }
                case 61: {
                    currentInstruction = new Bgt();
                    break;
                }
                case 48: {
                    currentInstruction = new BgtS();
                    break;
                }
                case 66: {
                    currentInstruction = new BgtUn();
                    break;
                }
                case 53: {
                    currentInstruction = new BgtUnS();
                    break;
                }
                case 62: {
                    currentInstruction = new Ble();
                    break;
                }
                case 49: {
                    currentInstruction = new BleS();
                    break;
                }
                case 67: {
                    currentInstruction = new BleUn();
                    break;
                }
                case 54: {
                    currentInstruction = new BleUnS();
                    break;
                }
                case 63: {
                    currentInstruction = new Blt();
                    break;
                }
                case 50: {
                    currentInstruction = new BltS();
                    break;
                }
                case 68: {
                    currentInstruction = new BltUn();
                    break;
                }
                case 55: {
                    currentInstruction = new BltUnS();
                    break;
                }
                case 64: {
                    currentInstruction = new BneUn();
                    break;
                }
                case 51: {
                    currentInstruction = new BneUnS();
                    break;
                }
                case 56: {
                    currentInstruction = new Br();
                    break;
                }
                case 43: {
                    currentInstruction = new BrS();
                    break;
                }
                case 1: {
                    currentInstruction = new Break();
                    break;
                }
                case 58: {
                    currentInstruction = new Brtrue();
                    break;
                }
                case 45: {
                    currentInstruction = new BrtrueS();
                    break;
                }
                case 57: {
                    currentInstruction = new Brfalse();
                    break;
                }
                case 44: {
                    currentInstruction = new BrfalseS();
                    break;
                }
                case 40: {
                    currentInstruction = new Call();
                    break;
                }
                case 41: {
                    currentInstruction = new Calli();
                    break;
                }
                case -61: {
                    currentInstruction = new Ckfinite();
                    break;
                }
                case -45: {
                    currentInstruction = new ConvI();
                    break;
                }
                case 103: {
                    currentInstruction = new ConvI1();
                    break;
                }
                case 104: {
                    currentInstruction = new ConvI2();
                    break;
                }
                case 105: {
                    currentInstruction = new ConvI4();
                    break;
                }
                case 106: {
                    currentInstruction = new ConvI8();
                    break;
                }
                case -44: {
                    currentInstruction = new ConvOvfI();
                    break;
                }
                case -77: {
                    currentInstruction = new ConvOvfI1();
                    break;
                }
                case -126: {
                    currentInstruction = new ConvOvfI1Un();
                    break;
                }
                case -75: {
                    currentInstruction = new ConvOvfI2();
                    break;
                }
                case -125: {
                    currentInstruction = new ConvOvfI2Un();
                    break;
                }
                case -73: {
                    currentInstruction = new ConvOvfI4();
                    break;
                }
                case -124: {
                    currentInstruction = new ConvOvfI4Un();
                    break;
                }
                case -71: {
                    currentInstruction = new ConvOvfI8();
                    break;
                }
                case -123: {
                    currentInstruction = new ConvOvfI8Un();
                    break;
                }
                case -118: {
                    currentInstruction = new ConvOvfIUn();
                    break;
                }
                case -43: {
                    currentInstruction = new ConvOvfU();
                    break;
                }
                case -76: {
                    currentInstruction = new ConvOvfU1();
                    break;
                }
                case -122: {
                    currentInstruction = new ConvOvfU1Un();
                    break;
                }
                case -74: {
                    currentInstruction = new ConvOvfU2();
                    break;
                }
                case -121: {
                    currentInstruction = new ConvOvfU2Un();
                    break;
                }
                case -72: {
                    currentInstruction = new ConvOvfU4();
                    break;
                }
                case -120: {
                    currentInstruction = new ConvOvfU4Un();
                    break;
                }
                case -70: {
                    currentInstruction = new ConvOvfU8();
                    break;
                }
                case -119: {
                    currentInstruction = new ConvOvfU8Un();
                    break;
                }
                case -117: {
                    currentInstruction = new ConvOvfUUn();
                    break;
                }
                case 107: {
                    currentInstruction = new ConvR4();
                    break;
                }
                case 108: {
                    currentInstruction = new ConvR8();
                    break;
                }
                case 118: {
                    currentInstruction = new ConvRUn();
                    break;
                }
                case -32: {
                    currentInstruction = new ConvU();
                    break;
                }
                case -46: {
                    currentInstruction = new ConvU1();
                    break;
                }
                case -47: {
                    currentInstruction = new ConvU2();
                    break;
                }
                case 109: {
                    currentInstruction = new ConvU4();
                    break;
                }
                case 110: {
                    currentInstruction = new ConvU8();
                    break;
                }
                case 91: {
                    currentInstruction = new Div();
                    break;
                }
                case 92: {
                    currentInstruction = new DivUn();
                    break;
                }
                case 37: {
                    currentInstruction = new Dup();
                    break;
                }
                case -36: {
                    currentInstruction = new Endfinally();
                    break;
                }
                case 39: {
                    currentInstruction = new Jmp();
                    break;
                }
                case 2: {
                    currentInstruction = new Ldarg0();
                    break;
                }
                case 3: {
                    currentInstruction = new Ldarg1();
                    break;
                }
                case 4: {
                    currentInstruction = new Ldarg2();
                    break;
                }
                case 5: {
                    currentInstruction = new Ldarg3();
                    break;
                }
                case 15: {
                    currentInstruction = new LdargaS();
                    break;
                }
                case 14: {
                    currentInstruction = new LdargS();
                    break;
                }
                case 32: {
                    currentInstruction = new LdcI4();
                    break;
                }
                case 22: {
                    currentInstruction = new LdcI40();
                    break;
                }
                case 23: {
                    currentInstruction = new LdcI41();
                    break;
                }
                case 24: {
                    currentInstruction = new LdcI42();
                    break;
                }
                case 25: {
                    currentInstruction = new LdcI43();
                    break;
                }
                case 26: {
                    currentInstruction = new LdcI44();
                    break;
                }
                case 27: {
                    currentInstruction = new LdcI45();
                    break;
                }
                case 28: {
                    currentInstruction = new LdcI46();
                    break;
                }
                case 29: {
                    currentInstruction = new LdcI47();
                    break;
                }
                case 30: {
                    currentInstruction = new LdcI48();
                    break;
                }
                case 21: {
                    currentInstruction = new LdcI4M1();
                    break;
                }
                case 31: {
                    currentInstruction = new LdcI4S();
                    break;
                }
                case 33: {
                    currentInstruction = new LdcI8();
                    break;
                }
                case 34: {
                    currentInstruction = new LdcR4();
                    break;
                }
                case 35: {
                    currentInstruction = new LdcR8();
                    break;
                }
                case 77: {
                    currentInstruction = new LdindI();
                    break;
                }
                case 70: {
                    currentInstruction = new LdindI1();
                    break;
                }
                case 72: {
                    currentInstruction = new LdindI2();
                    break;
                }
                case 74: {
                    currentInstruction = new LdindI4();
                    break;
                }
                case 76: {
                    currentInstruction = new LdindI8();
                    break;
                }
                case 78: {
                    currentInstruction = new LdindR4();
                    break;
                }
                case 79: {
                    currentInstruction = new LdindR8();
                    break;
                }
                case 80: {
                    currentInstruction = new LdindRef();
                    break;
                }
                case 71: {
                    currentInstruction = new LdindU1();
                    break;
                }
                case 73: {
                    currentInstruction = new LdindU2();
                    break;
                }
                case 75: {
                    currentInstruction = new LdindU4();
                    break;
                }
                case 6: {
                    currentInstruction = new Ldloc0();
                    break;
                }
                case 7: {
                    currentInstruction = new Ldloc1();
                    break;
                }
                case 8: {
                    currentInstruction = new Ldloc2();
                    break;
                }
                case 9: {
                    currentInstruction = new Ldloc3();
                    break;
                }
                case 18: {
                    currentInstruction = new LdlocaS();
                    break;
                }
                case 17: {
                    currentInstruction = new LdlocS();
                    break;
                }
                case 20: {
                    currentInstruction = new Ldnull();
                    break;
                }
                case -35: {
                    currentInstruction = new Leave();
                    break;
                }
                case -34: {
                    currentInstruction = new LeaveS();
                    break;
                }
                case 90: {
                    currentInstruction = new Mul();
                    break;
                }
                case -40: {
                    currentInstruction = new MulOvf();
                    break;
                }
                case -39: {
                    currentInstruction = new MulOvfUn();
                    break;
                }
                case 101: {
                    currentInstruction = new Neg();
                    break;
                }
                case 0: {
                    currentInstruction = new Nop();
                    break;
                }
                case 102: {
                    currentInstruction = new Not();
                    break;
                }
                case 96: {
                    currentInstruction = new Or();
                    break;
                }
                case 38: {
                    currentInstruction = new Pop();
                    break;
                }
                case 93: {
                    currentInstruction = new Rem();
                    break;
                }
                case 94: {
                    currentInstruction = new RemUn();
                    break;
                }
                case 42: {
                    currentInstruction = new Ret();
                    break;
                }
                case 98: {
                    currentInstruction = new Shl();
                    break;
                }
                case 99: {
                    currentInstruction = new Shr();
                    break;
                }
                case 100: {
                    currentInstruction = new ShrUn();
                    break;
                }
                case 16: {
                    currentInstruction = new StargS();
                    break;
                }
                case -33: {
                    currentInstruction = new StindI();
                    break;
                }
                case 82: {
                    currentInstruction = new StindI1();
                    break;
                }
                case 83: {
                    currentInstruction = new StindI2();
                    break;
                }
                case 84: {
                    currentInstruction = new StindI4();
                    break;
                }
                case 85: {
                    currentInstruction = new StindI8();
                    break;
                }
                case 86: {
                    currentInstruction = new StindR4();
                    break;
                }
                case 87: {
                    currentInstruction = new StindR8();
                    break;
                }
                case 81: {
                    currentInstruction = new StindRef();
                    break;
                }
                case 10: {
                    currentInstruction = new Stloc0();
                    break;
                }
                case 11: {
                    currentInstruction = new Stloc1();
                    break;
                }
                case 12: {
                    currentInstruction = new Stloc2();
                    break;
                }
                case 13: {
                    currentInstruction = new Stloc3();
                    break;
                }
                case 19: {
                    currentInstruction = new StlocS();
                    break;
                }
                case 89: {
                    currentInstruction = new Sub();
                    break;
                }
                case -38: {
                    currentInstruction = new SubOvf();
                    break;
                }
                case -37: {
                    currentInstruction = new SubOvfUn();
                    break;
                }
                case 69: {
                    currentInstruction = new Switch();
                    break;
                }
                case 97: {
                    currentInstruction = new Xor();
                    break;
                }
                case -116: {
                    currentInstruction = new Box();
                    break;
                }
                case 111: {
                    currentInstruction = new Callvirt();
                    break;
                }
                case 116: {
                    currentInstruction = new Castclass();
                    break;
                }
                case 112: {
                    currentInstruction = new Cpobj();
                    break;
                }
                case 117: {
                    currentInstruction = new Isinst();
                    break;
                }
                case -93: {
                    currentInstruction = new Ldelem();
                    break;
                }
                case -113: {
                    currentInstruction = new Ldelema();
                    break;
                }
                case -105: {
                    currentInstruction = new LdelemI();
                    break;
                }
                case -112: {
                    currentInstruction = new LdelemI1();
                    break;
                }
                case -110: {
                    currentInstruction = new LdelemI2();
                    break;
                }
                case -108: {
                    currentInstruction = new LdelemI4();
                    break;
                }
                case -106: {
                    currentInstruction = new LdelemI8();
                    break;
                }
                case -104: {
                    currentInstruction = new LdelemR4();
                    break;
                }
                case -103: {
                    currentInstruction = new LdelemR8();
                    break;
                }
                case -102: {
                    currentInstruction = new LdelemRef();
                    break;
                }
                case -111: {
                    currentInstruction = new LdelemU1();
                    break;
                }
                case -109: {
                    currentInstruction = new LdelemU2();
                    break;
                }
                case -107: {
                    currentInstruction = new LdelemU4();
                    break;
                }
                case 123: {
                    currentInstruction = new Ldfld();
                    break;
                }
                case 124: {
                    currentInstruction = new Ldflda();
                    break;
                }
                case -114: {
                    currentInstruction = new Ldlen();
                    break;
                }
                case 113: {
                    currentInstruction = new Ldobj();
                    break;
                }
                case 126: {
                    currentInstruction = new Ldsfld();
                    break;
                }
                case 127: {
                    currentInstruction = new Ldsflda();
                    break;
                }
                case 114: {
                    currentInstruction = new Ldstr();
                    break;
                }
                case -48: {
                    currentInstruction = new Ldtoken();
                    break;
                }
                case -58: {
                    currentInstruction = new Mkrefany();
                    break;
                }
                case -115: {
                    currentInstruction = new Newarr();
                    break;
                }
                case 115: {
                    currentInstruction = new Newobj();
                    break;
                }
                case -62: {
                    currentInstruction = new Refanyval();
                    break;
                }
                case -92: {
                    currentInstruction = new Stelem();
                    break;
                }
                case -101: {
                    currentInstruction = new StelemI();
                    break;
                }
                case -100: {
                    currentInstruction = new StelemI1();
                    break;
                }
                case -99: {
                    currentInstruction = new StelemI2();
                    break;
                }
                case -98: {
                    currentInstruction = new StelemI4();
                    break;
                }
                case -97: {
                    currentInstruction = new StelemI8();
                    break;
                }
                case -96: {
                    currentInstruction = new StelemR4();
                    break;
                }
                case -95: {
                    currentInstruction = new StelemR8();
                    break;
                }
                case -94: {
                    currentInstruction = new StelemRef();
                    break;
                }
                case 125: {
                    currentInstruction = new Stfld();
                    break;
                }
                case -127: {
                    currentInstruction = new Stobj();
                    break;
                }
                case -128: {
                    currentInstruction = new Stsfld();
                    break;
                }
                case 122: {
                    currentInstruction = new Throw();
                    break;
                }
                case 121: {
                    currentInstruction = new Unbox();
                    break;
                }
                case -91: {
                    currentInstruction = new UnboxAny();
                    break;
                }
                case -2: {
                    switch (data[index + 1]) {
                        case 22: {
                            currentInstruction = new Constrained();
                            break;
                        }
                        case 25: {
                            currentInstruction = new No();
                            break;
                        }
                        case 30: {
                            currentInstruction = new ReadOnly();
                            break;
                        }
                        case 20: {
                            currentInstruction = new Tail();
                            break;
                        }
                        case 18: {
                            currentInstruction = new Unaligned();
                            break;
                        }
                        case 19: {
                            currentInstruction = new Volatile();
                            break;
                        }
                        case 0: {
                            currentInstruction = new ArgList();
                            break;
                        }
                        case 1: {
                            currentInstruction = new Ceq();
                            break;
                        }
                        case 2: {
                            currentInstruction = new Cgt();
                            break;
                        }
                        case 3: {
                            currentInstruction = new CgtUn();
                            break;
                        }
                        case 5: {
                            currentInstruction = new Clt();
                            break;
                        }
                        case 4: {
                            currentInstruction = new CltUn();
                            break;
                        }
                        case 23: {
                            currentInstruction = new Cpblk();
                            break;
                        }
                        case 17: {
                            currentInstruction = new Endfilter();
                            break;
                        }
                        case 24: {
                            currentInstruction = new Initblk();
                            break;
                        }
                        case 9: {
                            currentInstruction = new Ldarg();
                            break;
                        }
                        case 10: {
                            currentInstruction = new Ldarga();
                            break;
                        }
                        case 6: {
                            currentInstruction = new Ldftn();
                            break;
                        }
                        case 12: {
                            currentInstruction = new Ldloc();
                            break;
                        }
                        case 13: {
                            currentInstruction = new Ldloca();
                            break;
                        }
                        case 15: {
                            currentInstruction = new Localloc();
                            break;
                        }
                        case 11: {
                            currentInstruction = new Starg();
                            break;
                        }
                        case 14: {
                            currentInstruction = new Stloc();
                            break;
                        }
                        case 21: {
                            currentInstruction = new Initobj();
                            break;
                        }
                        case 7: {
                            currentInstruction = new Ldvirtftn();
                            break;
                        }
                        case 29: {
                            currentInstruction = new Refanytype();
                            break;
                        }
                        case 26: {
                            currentInstruction = new Rethrow();
                            break;
                        }
                        case 28: {
                            currentInstruction = new Sizeof();
                        }
                    }
                    break;
                }
                default: {
                    assert (false) : "Unknown CIL Instruction";
                    break;
                }
            }
            assert (currentInstruction != null);
            instructions.add((Add)currentInstruction);
        }
        return instructions.toArray(new CilInstruction[instructions.size()]);
    }

    public int getFlags() {
        return this.flags;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public long getLocalVarSignatureToken() {
        return this.localVarSignatureToken;
    }

    public ExceptionClause[] getExceptionClauses() {
        if (this.exceptionClauses == null) {
            return new ExceptionClause[0];
        }
        return this.exceptionClauses;
    }

    public long getCodeSize() {
        return this.codeSize;
    }

    public void setLocalVars(TypeRef[] localVars) {
        this.localVars = localVars;
    }

    public TypeRef[] getLocalVars() {
        if (this.localVars == null) {
            return new TypeRef[0];
        }
        return this.localVars;
    }

    public CilInstruction[] getCilInstructions() {
        if (this.cilInstructions == null) {
            return new CilInstruction[0];
        }
        return this.cilInstructions;
    }

    public long getMethodToken() {
        return this.methodToken;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("Method Body:");
        buffer.append(String.format("\n\t Flags: 0x%04x", this.flags));
        buffer.append("\tHeaderSize: ");
        buffer.append(this.headerSize);
        buffer.append(" bytes");
        buffer.append("\n\tCodeSize: ");
        buffer.append(this.codeSize);
        buffer.append(" bytes");
        buffer.append("\tMaxStack: ");
        buffer.append(this.maxStack);
        buffer.append(String.format("\tToken: 0x%08x", this.localVarSignatureToken));
        int index = 0;
        if (this.localVars != null) {
            buffer.append("\n\n\t Locals:");
            for (TypeRef typeRef : this.localVars) {
                buffer.append("\n\t\t");
                buffer.append(typeRef.getFullQualifiedName());
                buffer.append(" $");
                buffer.append(index);
                buffer.append(";");
                ++index;
            }
        }
        buffer.append("\n\n\tCIL: ");
        int programCounter = 0;
        for (CilInstruction i : this.getCilInstructions()) {
            buffer.append(String.format("\nIL_%04x: %s", programCounter, i.render(null)));
            programCounter += i.getByteSize();
        }
        if (this.exceptionClauses != null) {
            buffer.append("\n\n\tExceptions: ");
            for (ExceptionClause ex : this.exceptionClauses) {
                buffer.append("\n\t\t");
                buffer.append(ex.toString());
            }
        }
        return buffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.codeSize;
        result = 31 * result + Arrays.hashCode(this.exceptionClauses);
        result = 31 * result + this.flags;
        result = 31 * result + this.maxStack;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodBody other = (MethodBody)obj;
        if (this.codeSize != other.codeSize) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (this.headerSize != other.headerSize) {
            return false;
        }
        if (this.maxStack != other.maxStack) {
            return false;
        }
        if (this.localVars == null) {
            if (other.localVars != null) {
                return false;
            }
        } else {
            if (other.localVars == null) {
                return false;
            }
            if (this.localVars.length != other.localVars.length) {
                return false;
            }
            for (int i = 0; i < this.localVars.length; ++i) {
                String name = this.localVars[i].getFullQualifiedName();
                String otherName = other.localVars[i].getFullQualifiedName();
                if (name == null || otherName == null || name.equals(otherName)) continue;
                return false;
            }
        }
        if (!Arrays.equals(this.exceptionClauses, other.exceptionClauses)) {
            return false;
        }
        if (this.cilInstructions != null) {
            if (other.cilInstructions != null && this.cilInstructions.length == other.cilInstructions.length) {
                for (int i = 0; i < this.cilInstructions.length; ++i) {
                    if (this.cilInstructions[i].equals(other.cilInstructions[i])) continue;
                    return false;
                }
            }
        } else if (other.cilInstructions != null) {
            return false;
        }
        return true;
    }
}

