/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.code;

import at.pollaknet.api.facile.exception.InvalidMethodBodyException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.util.ByteReader;

public class ExceptionClause {
    public static final long FLAGS_CATCH_TYPE = 0L;
    public static final long FLAGS_FILTER_TYPE = 1L;
    public static final long FLAGS_FINAL_TYPE = 2L;
    public static final long FLAGS_FAULT_TYPE = 4L;
    public static final long FLAGS_BIT_MASK = 7L;
    private boolean fatClause;
    private long flags;
    private long tryOffset;
    private long tryLength;
    private long handlerOffset;
    private long handlerLength;
    private long filterOffset;
    private TypeRef exceptionClass;
    public static final int SIZE_OF_TINY_EXCEPTION_CLAUSE = 12;
    public static final int SIZE_OF_FAT_EXCEPTION_CLAUSE = 24;

    public ExceptionClause(boolean fatClauses) {
        this.fatClause = fatClauses;
    }

    public int extract(MetadataModel metaModel, byte[] data, int offset) throws InvalidMethodBodyException {
        int byteCounter = offset;
        if (this.fatClause) {
            this.flags = ByteReader.getUInt32(data, byteCounter);
            this.tryOffset = ByteReader.getUInt32(data, byteCounter += 4);
            this.tryLength = ByteReader.getUInt32(data, byteCounter += 4);
            this.handlerOffset = ByteReader.getUInt32(data, byteCounter += 4);
            this.handlerLength = ByteReader.getUInt32(data, byteCounter += 4);
            this.filterOffset = ByteReader.getUInt32(data, byteCounter += 4);
            byteCounter += 4;
        } else {
            this.flags = ByteReader.getUInt16(data, byteCounter);
            this.tryOffset = ByteReader.getUInt16(data, byteCounter += 2);
            this.tryLength = ByteReader.getUInt8(data, byteCounter += 2);
            this.handlerOffset = ByteReader.getUInt16(data, ++byteCounter);
            this.handlerLength = ByteReader.getUInt8(data, byteCounter += 2);
            this.filterOffset = ByteReader.getUInt32(data, ++byteCounter);
            byteCounter += 4;
        }
        if (this.flags == 0L && this.filterOffset != 0L) {
            assert ((long)((int)this.filterOffset) == this.filterOffset);
            RenderableCilElement e = metaModel.getEntryByToken((int)this.filterOffset);
            if (e instanceof TypeRef) {
                this.exceptionClass = (TypeRef)((Object)e);
            } else {
                throw new InvalidMethodBodyException(String.format("Unable to identify exception class via token 0x%08x", this.filterOffset));
            }
        }
        return byteCounter - offset;
    }

    public long getFlags() {
        return this.flags;
    }

    public long getTryOffset() {
        return this.tryOffset;
    }

    public long getTryLength() {
        return this.tryLength;
    }

    public long getHandlerOffset() {
        return this.handlerOffset;
    }

    public long getHandlerLength() {
        return this.handlerLength;
    }

    public TypeRef getExceptionType() {
        return this.exceptionClass;
    }

    public long getFilterOffset() {
        return this.filterOffset;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + (int)(this.filterOffset ^ this.filterOffset >>> 32);
        result = 31 * result + (int)(this.handlerOffset ^ this.handlerOffset >>> 32);
        result = 31 * result + (int)(this.tryOffset ^ this.tryOffset >>> 32);
        result = 31 * result + (int)(this.flags ^ this.flags >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionClause other = (ExceptionClause)obj;
        if (this.exceptionClass == null ? other.exceptionClass != null : !this.exceptionClass.getFullQualifiedName().equals(other.exceptionClass.getFullQualifiedName())) {
            return false;
        }
        if (this.fatClause != other.fatClause) {
            return false;
        }
        if (this.filterOffset != other.filterOffset) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (this.handlerLength != other.handlerLength) {
            return false;
        }
        if (this.handlerOffset != other.handlerOffset) {
            return false;
        }
        if (this.tryLength != other.tryLength) {
            return false;
        }
        return this.tryOffset == other.tryOffset;
    }
}

