/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile;

import at.pollaknet.api.facile.FacileLogHandler;
import at.pollaknet.api.facile.code.CilContainer;
import at.pollaknet.api.facile.exception.CoffPeDataNotFoundException;
import at.pollaknet.api.facile.exception.DotNetContentNotFoundException;
import at.pollaknet.api.facile.exception.NativeImplementationException;
import at.pollaknet.api.facile.exception.SizeMismatchException;
import at.pollaknet.api.facile.exception.UnexpectedHeaderDataException;
import at.pollaknet.api.facile.header.cli.CliHeader;
import at.pollaknet.api.facile.header.cli.CliMetadataRootHeader;
import at.pollaknet.api.facile.header.cli.StreamHeader;
import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UnknownStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.coffpe.COFFPEHeader;
import at.pollaknet.api.facile.header.coffpe.DOSHeader;
import at.pollaknet.api.facile.header.coffpe.PEDataDirectories;
import at.pollaknet.api.facile.header.coffpe.PEOptionalHeader;
import at.pollaknet.api.facile.header.coffpe.PESectionHeader;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.entries.AssemblyEntry;
import at.pollaknet.api.facile.pdb.UnexpectedPdbContent;
import at.pollaknet.api.facile.pdb.dia.NativePdbReader;
import at.pollaknet.api.facile.symtab.SymbolTable;
import at.pollaknet.api.facile.symtab.symbols.scopes.Assembly;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FacileReflector {
    public static final String LOGGER_NAME = "at.pollaknet.api.facile";
    private static final int DEFAULT_PARTIAL_LOADING_SIZE = 0x800000;
    private boolean haltOnErrors = true;
    private boolean haltOnJniErrors = true;
    private static final String STREAM_SIGNATURE_METADATA = "#~";
    private static final String STREAM_SIGNATURE_STRINGS = "#Strings";
    private static final String STREAM_SIGNATURE_US = "#US";
    private static final String STREAM_SIGNATURE_GUID = "#GUID";
    private static final String STREAM_SIGNATURE_BLOB = "#Blob";
    private static final String STREAM_SIGNATURE_METADATA_ALTERNATIVE = "#-";
    private PEDataDirectories peDataDirectories;
    PriorityQueue<PESectionHeader> peSectionHeaders = new PriorityQueue();
    private int numberOfSections;
    private CliHeader cliHeader;
    private CliMetadataRootHeader cliMetadataRootHeader;
    private MetadataStream metadataStream;
    private StringsStream stringsStream;
    private UserStringStream userStringStream;
    private GuidStream guidStream;
    private BlobStream blobStream;
    private List<UnknownStream> additionalStreams = new ArrayList<UnknownStream>();
    private Map<String, Integer> additionalStreamsSetup = new HashMap<String, Integer>();
    private int sizeOfMetadataStream;
    private int sizeOfStringsStream;
    private int sizeOfUserStringStream;
    private int sizeOfGuidStream;
    private int sizeOfBlobStream;
    private int indexOfMetadataStream = -1;
    private int indexOfStringsStream = -1;
    private int indexOfUserStringStream = -1;
    private int indexOfGuidStream = -1;
    private int indexOfBlobStream = -1;
    private int cliMetadataRootHeaderPA;
    private int cliHeaderPA;
    private MetadataModel metaModel;
    private AssemblyEntry assembly = null;
    private CilContainer codeContainer;
    private String pathToAssembly = null;
    private String pathToPdb = null;
    private DOSHeader dosHeader;
    private COFFPEHeader coffPeHeader;
    private PEOptionalHeader peOptionalHeader;
    private boolean assemblyHasIlSection = false;
    private boolean partialLoaded = false;
    private static Logger logger;
    private static FacileLogHandler facileLogHandler;
    private boolean debugDataAvailable = false;
    private int partialLoadingSizeInBytes = 0x800000;
    private List<Assembly> referenceAssemblies = new ArrayList<Assembly>(4);
    private Map<String, Byte> referneceEnums = new HashMap<String, Byte>(8);

    private FacileReflector() {
        this.addReferneceEnum("System.Security.SecurityRuleSet", (byte)1);
        this.addReferneceEnum("System.Windows.Visibility", (byte)1);
        this.addReferneceEnum("System.Diagnostics.Tracing.EventKeywords", (byte)8);
        this.addReferneceEnum("MonoTouch.ObjCRuntime.Platform", (byte)8);
        this.addReferneceEnum("Microsoft.Diagnostics.Tracing.EventKeywords", (byte)8);
        logger.info(String.format("Created Instance 0x%x", this.hashCode()));
    }

    FacileReflector(String pathToAssembly) throws CoffPeDataNotFoundException, UnexpectedHeaderDataException, SizeMismatchException, IOException {
        this();
        this.pathToAssembly = pathToAssembly;
        this.pathToPdb = pathToAssembly;
        byte[] buffer = this.getFileBuffer(pathToAssembly);
        this.processAssemblyTables(buffer);
    }

    FacileReflector(String pathToAssembly, String pathToPdb) throws CoffPeDataNotFoundException, UnexpectedHeaderDataException, SizeMismatchException, IOException {
        this();
        this.pathToAssembly = pathToAssembly;
        this.pathToPdb = pathToPdb;
        byte[] buffer = this.getFileBuffer(pathToAssembly);
        this.processAssemblyTables(buffer);
    }

    FacileReflector(byte[] buffer) throws CoffPeDataNotFoundException, UnexpectedHeaderDataException, SizeMismatchException {
        this();
        try {
            this.processAssemblyTables(buffer);
        }
        catch (IOException e) {
            logger.info(e.getMessage());
        }
    }

    private void processAssemblyTables(byte[] buffer) throws CoffPeDataNotFoundException, UnexpectedHeaderDataException, SizeMismatchException, IOException {
        if (this.pathToAssembly != null && this.pathToPdb != null) {
            logger.log(Level.INFO, "Assembly: " + this.pathToAssembly);
            logger.log(Level.INFO, "Pdb: " + this.pathToPdb);
        } else {
            logger.log(Level.INFO, "No file specified. Using a byte buffer as source!");
            this.pathToAssembly = "<byte[]:" + Arrays.hashCode(buffer) + ">";
        }
        logger.log(Level.INFO, "Starting COFF/PE processing.");
        assert (buffer != null);
        this.processCoffPeData(buffer);
        logger.log(Level.INFO, "Finished COFF/PE processing.");
        logger.log(Level.INFO, "Starting CIL processing.");
        this.codeContainer = new CilContainer();
        this.processCilData(buffer);
        logger.log(Level.INFO, "Finished CIL processing.");
        logger.log(Level.INFO, "Deleting file buffer.");
        buffer = null;
    }

    private void processCilData(byte[] buffer) throws UnexpectedHeaderDataException, SizeMismatchException, DotNetContentNotFoundException, IOException {
        String msg;
        int byteOffset;
        StreamHeader streamHeader;
        this.cliHeader = new CliHeader();
        PESectionHeader fileSection = null;
        long clrHeaderRVA = this.peDataDirectories.getClrHeaderRVA();
        for (PESectionHeader header : this.peSectionHeaders) {
            if (header.getRelativeVirtualAddress() > clrHeaderRVA) continue;
            fileSection = header;
        }
        this.codeContainer.setPeFileSections(this.peSectionHeaders.toArray(new PESectionHeader[this.peSectionHeaders.size()]));
        if (fileSection == null) {
            throw new DotNetContentNotFoundException("No CLR Header found.");
        }
        assert (fileSection.getPointerToRawData() < Integer.MAX_VALUE);
        int fileSectionPA = (int)fileSection.getPointerToRawData();
        long fileSectionRVA = fileSection.getRelativeVirtualAddress();
        long offsetToData = this.peDataDirectories.getClrHeaderRVA() - fileSectionRVA;
        assert ((long)fileSectionPA + offsetToData < Integer.MAX_VALUE);
        this.cliHeaderPA = (int)((long)this.cliHeaderPA + ((long)fileSectionPA + offsetToData));
        if (this.partialLoaded && this.cliHeaderPA + 72 > this.partialLoadingSizeInBytes) {
            buffer = this.getFileBuffer(this.pathToAssembly);
        }
        if (this.cliHeaderPA > buffer.length - 72) {
            throw new DotNetContentNotFoundException("No CLR Header found.");
        }
        this.cliHeader.read(buffer, this.cliHeaderPA);
        this.cliMetadataRootHeader = new CliMetadataRootHeader();
        if (this.cliHeader.getSizeOfMetadataDirectory() <= 0L) {
            for (PESectionHeader sectionHeader : this.peSectionHeaders) {
                if (!sectionHeader.getSectionName().startsWith(".il")) continue;
                fileSectionRVA = 0L;
                assert (sectionHeader.getPointerToRawData() <= Integer.MAX_VALUE);
                fileSectionPA = (int)sectionHeader.getPointerToRawData();
                this.assemblyHasIlSection = true;
            }
        }
        offsetToData = this.cliHeader.getAddrOfMetadataDirectory() - fileSectionRVA;
        assert ((long)fileSectionPA + offsetToData < Integer.MAX_VALUE);
        this.cliMetadataRootHeaderPA = (int)((long)fileSectionPA + offsetToData);
        if (this.cliMetadataRootHeaderPA < 0) {
            throw new DotNetContentNotFoundException("No CLI metadata header found!");
        }
        if (this.partialLoaded) {
            buffer = this.getFileBuffer(this.pathToAssembly);
        }
        this.cliMetadataRootHeader.read(buffer, this.cliMetadataRootHeaderPA);
        this.codeContainer.setCodeBuffer(buffer);
        this.getStreamIndices();
        if (this.indexOfMetadataStream >= 0) {
            this.metadataStream = new MetadataStream(this.cliMetadataRootHeader.isUnoptimized());
            streamHeader = this.cliMetadataRootHeader.getStreamHeaders()[this.indexOfMetadataStream];
            offsetToData = streamHeader.getStreamOffset();
            assert ((long)this.cliMetadataRootHeaderPA + offsetToData < Integer.MAX_VALUE);
            byteOffset = (int)((long)this.cliMetadataRootHeaderPA + offsetToData);
            this.sizeOfMetadataStream = this.metadataStream.read(buffer, byteOffset);
        } else {
            logger.info("File contains no metadata.");
        }
        if (this.indexOfStringsStream >= 0) {
            streamHeader = this.cliMetadataRootHeader.getStreamHeaders()[this.indexOfStringsStream];
            assert (streamHeader.getStreamSize() < Integer.MAX_VALUE);
            this.stringsStream = new StringsStream((int)streamHeader.getStreamSize());
            offsetToData = streamHeader.getStreamOffset();
            assert ((long)this.cliMetadataRootHeaderPA + offsetToData < Integer.MAX_VALUE);
            byteOffset = (int)((long)this.cliMetadataRootHeaderPA + offsetToData);
            this.sizeOfStringsStream = this.stringsStream.read(buffer, byteOffset);
            if ((long)this.sizeOfStringsStream != streamHeader.getStreamSize()) {
                msg = "\nThe size of the #Strings stream content is not equal to the header information.\n(" + this.sizeOfStringsStream + " instead of " + streamHeader.getStreamSize() + ")";
                throw new SizeMismatchException(msg);
            }
        }
        if (this.indexOfUserStringStream >= 0) {
            streamHeader = this.cliMetadataRootHeader.getStreamHeaders()[this.indexOfUserStringStream];
            assert (streamHeader.getStreamSize() < Integer.MAX_VALUE);
            this.userStringStream = new UserStringStream((int)streamHeader.getStreamSize());
            offsetToData = streamHeader.getStreamOffset();
            assert ((long)this.cliMetadataRootHeaderPA + offsetToData < Integer.MAX_VALUE);
            byteOffset = (int)((long)this.cliMetadataRootHeaderPA + offsetToData);
            this.sizeOfUserStringStream = this.userStringStream.read(buffer, byteOffset);
            if ((long)this.sizeOfUserStringStream != streamHeader.getStreamSize()) {
                msg = "\nThe size of the #US stream content is not equal to the header information.\n(" + this.sizeOfUserStringStream + " instead of " + streamHeader.getStreamSize() + ")";
                throw new SizeMismatchException(msg);
            }
        }
        if (this.indexOfGuidStream >= 0) {
            streamHeader = this.cliMetadataRootHeader.getStreamHeaders()[this.indexOfGuidStream];
            assert (streamHeader.getStreamSize() < Integer.MAX_VALUE);
            this.guidStream = new GuidStream((int)streamHeader.getStreamSize());
            offsetToData = streamHeader.getStreamOffset();
            assert ((long)this.cliMetadataRootHeaderPA + offsetToData < Integer.MAX_VALUE);
            byteOffset = (int)((long)this.cliMetadataRootHeaderPA + offsetToData);
            this.sizeOfGuidStream = this.guidStream.read(buffer, byteOffset);
            if ((long)this.sizeOfGuidStream != streamHeader.getStreamSize()) {
                msg = "\nThe size of the #GUID stream content is not equal to the header information.\n(" + this.sizeOfGuidStream + " instead of " + streamHeader.getStreamSize() + ")";
                throw new SizeMismatchException(msg);
            }
        }
        if (this.indexOfBlobStream >= 0) {
            streamHeader = this.cliMetadataRootHeader.getStreamHeaders()[this.indexOfBlobStream];
            assert (streamHeader.getStreamSize() < Integer.MAX_VALUE);
            this.blobStream = new BlobStream((int)streamHeader.getStreamSize());
            offsetToData = streamHeader.getStreamOffset();
            assert ((long)this.cliMetadataRootHeaderPA + offsetToData < Integer.MAX_VALUE);
            byteOffset = (int)((long)this.cliMetadataRootHeaderPA + offsetToData);
            this.sizeOfBlobStream = this.blobStream.read(buffer, byteOffset);
            if ((long)this.sizeOfBlobStream != streamHeader.getStreamSize()) {
                msg = "\nThe size of the #Blob stream content is not equal to the header information.\n(" + this.sizeOfBlobStream + " instead of " + streamHeader.getStreamSize() + ")";
                throw new SizeMismatchException(msg);
            }
        }
        if (!this.additionalStreamsSetup.isEmpty()) {
            for (String name : this.additionalStreamsSetup.keySet()) {
                int index = this.additionalStreamsSetup.get(name);
                streamHeader = this.cliMetadataRootHeader.getStreamHeaders()[index];
                assert (streamHeader.getStreamSize() < Integer.MAX_VALUE);
                UnknownStream unknownStream = new UnknownStream(streamHeader.getName(), (int)streamHeader.getStreamSize());
                offsetToData = streamHeader.getStreamOffset();
                assert ((long)this.cliMetadataRootHeaderPA + offsetToData < Integer.MAX_VALUE);
                byteOffset = (int)((long)this.cliMetadataRootHeaderPA + offsetToData);
                unknownStream.read(buffer, byteOffset);
                this.additionalStreams.add(unknownStream);
            }
        }
    }

    private void getStreamIndices() throws DotNetContentNotFoundException {
        block15: for (int index = 0; index < this.cliMetadataRootHeader.getStreamHeaders().length; ++index) {
            String name;
            switch (name = this.cliMetadataRootHeader.getStreamHeaders()[index].getName()) {
                case "#~": 
                case "#-": {
                    this.indexOfMetadataStream = index;
                    continue block15;
                }
                case "#Strings": {
                    this.indexOfStringsStream = index;
                    continue block15;
                }
                case "#US": {
                    this.indexOfUserStringStream = index;
                    continue block15;
                }
                case "#GUID": {
                    this.indexOfGuidStream = index;
                    continue block15;
                }
                case "#Blob": {
                    this.indexOfBlobStream = index;
                    continue block15;
                }
                default: {
                    this.additionalStreamsSetup.put(name, index);
                    logger.severe("Unknown stream (" + name + ") detected!");
                }
            }
        }
        if (this.indexOfMetadataStream == -1 && this.indexOfStringsStream == -1 && this.indexOfUserStringStream == -1 && this.indexOfGuidStream == -1 && this.indexOfBlobStream == -1) {
            throw new DotNetContentNotFoundException("All .net streams are missing.");
        }
    }

    private void processCoffPeData(byte[] buffer) throws UnexpectedHeaderDataException, CoffPeDataNotFoundException {
        int byteOffset = 0;
        this.dosHeader = new DOSHeader();
        this.dosHeader.read(buffer, byteOffset);
        if (this.dosHeader.getFileAddrOfCOFFHeader() > (long)(buffer.length - 24)) {
            throw new CoffPeDataNotFoundException("No COFF header found.");
        }
        assert (this.dosHeader.getFileAddrOfCOFFHeader() < Integer.MAX_VALUE);
        byteOffset = (int)this.dosHeader.getFileAddrOfCOFFHeader();
        this.coffPeHeader = new COFFPEHeader();
        byteOffset += this.coffPeHeader.read(buffer, byteOffset);
        this.peOptionalHeader = new PEOptionalHeader();
        byteOffset += this.peOptionalHeader.read(buffer, byteOffset);
        this.peDataDirectories = new PEDataDirectories();
        byteOffset += this.peDataDirectories.read(buffer, byteOffset);
        this.numberOfSections = this.coffPeHeader.getNumberOfSections();
        for (int i = 0; i < this.numberOfSections; ++i) {
            PESectionHeader header = new PESectionHeader();
            byteOffset += header.read(buffer, byteOffset);
            this.peSectionHeaders.add(header);
        }
    }

    private byte[] getFileBuffer(String pathToFile) throws IOException, SizeMismatchException {
        RandomAccessFile file = new RandomAccessFile(pathToFile, "r");
        long length = file.length();
        if (length < 0L || length > Integer.MAX_VALUE) {
            file.close();
            throw new SizeMismatchException("Size limit of 2147483647bytes exceeded");
        }
        int bufferLength = (int)length;
        if (!this.partialLoaded && bufferLength > this.partialLoadingSizeInBytes) {
            bufferLength = this.partialLoadingSizeInBytes;
            this.partialLoaded = true;
        }
        byte[] buffer = new byte[bufferLength];
        file.read(buffer, 0, bufferLength);
        assert (this.partialLoaded || file.read() == -1);
        file.close();
        return buffer;
    }

    public Assembly loadAssembly() throws DotNetContentNotFoundException {
        return this.loadAssembly(true);
    }

    public Assembly loadAssembly(boolean loadByteCode) throws DotNetContentNotFoundException {
        if (this.assembly == null) {
            int slashPos;
            if (this.metadataStream == null) {
                return null;
            }
            logger.log(Level.INFO, "Starting meta object processing.");
            String separator = System.getProperty("file.separator");
            if (separator == null) {
                separator = "/";
            }
            String alternativeModuleName = (slashPos = this.pathToAssembly.lastIndexOf(separator) + 1) > 1 ? this.pathToAssembly.substring(slashPos) : this.pathToAssembly;
            this.metaModel = new MetadataModel(this.assemblyHasIlSection, alternativeModuleName, this.metadataStream, this.stringsStream, this.userStringStream, this.guidStream, this.blobStream, loadByteCode);
            logger.log(Level.INFO, "Finished meta object processing.");
            if (this.metaModel.assembly.length < 1) {
                if (this.metaModel.module.length < 1) {
                    throw new DotNetContentNotFoundException("No assembly entry and no module entry has been found!");
                }
                assert (this.metaModel.module[0] != null);
                this.assembly = new AssemblyEntry();
                this.assembly.setName("Stub [" + this.metaModel.module[0].getName() + "]");
                this.metaModel.assembly = new AssemblyEntry[1];
                this.metaModel.assembly[0] = this.assembly;
            } else {
                this.assembly = this.metaModel.assembly[0];
            }
            logger.log(Level.INFO, "Try to access debug information.");
            NativePdbReader pdbReader = this.openPdb();
            logger.log(Level.INFO, "Starting symbol table processing.");
            SymbolTable symbolTable = new SymbolTable(this.cliHeader, this.metaModel, this.blobStream, this.codeContainer, pdbReader, this.pathToAssembly);
            symbolTable.build(this);
            if (pdbReader != null) {
                pdbReader.close();
                pdbReader = null;
                logger.log(Level.INFO, "PDB has been closed.");
                this.debugDataAvailable = true;
            }
            logger.log(Level.INFO, "Finished symbol table processing.");
        }
        return this.assembly;
    }

    private NativePdbReader openPdb() {
        if (this.pathToPdb == null) {
            logger.log(Level.INFO, "No PDB specified.");
            return null;
        }
        NativePdbReader pdbReader = null;
        try {
            pdbReader = new NativePdbReader();
            pdbReader.open(this.pathToPdb);
            logger.log(Level.INFO, "Successfully opened PDB.");
        }
        catch (FileNotFoundException e) {
            if (this.pathToAssembly.equals(this.pathToPdb)) {
                int pos = this.pathToAssembly.lastIndexOf(46);
                assert (pos > 0);
                String alternativePath = this.pathToAssembly.substring(0, pos) + ".pdb";
                logger.log(Level.INFO, "PDB not found. Using " + alternativePath + " as alternative.");
                try {
                    pdbReader = new NativePdbReader();
                    pdbReader.open(alternativePath);
                    logger.log(Level.INFO, "Successfully opened alternative PDB.");
                }
                catch (FileNotFoundException ex) {
                    logger.log(Level.WARNING, "PDB not opened: " + ex.getMessage());
                    pdbReader = null;
                }
                catch (NativeImplementationException ex) {
                    logger.log(Level.WARNING, "PDB not opened: " + ex.getMessage());
                    pdbReader = null;
                }
                catch (UnexpectedPdbContent ex) {
                    logger.log(Level.WARNING, "PDB not opened: " + ex.getMessage());
                    pdbReader = null;
                }
            } else {
                logger.log(Level.WARNING, "PDB not opened: " + e.getMessage());
            }
        }
        catch (NativeImplementationException e) {
            logger.log(Level.WARNING, "PDB not opened: " + e.getMessage());
            pdbReader = null;
        }
        catch (UnexpectedPdbContent e) {
            logger.log(Level.WARNING, "PDB not opened: " + e.getMessage());
            pdbReader = null;
        }
        return pdbReader;
    }

    public String getPathToAssemby() {
        return this.pathToAssembly;
    }

    public String getPathToPdb() {
        return this.pathToPdb;
    }

    public CliHeader getCliHeader() {
        return this.cliHeader;
    }

    public CliMetadataRootHeader getCliMetadataRootHeader() {
        return this.cliMetadataRootHeader;
    }

    public MetadataStream getMetadataStream() {
        return this.metadataStream;
    }

    public StringsStream getStringsStream() {
        return this.stringsStream;
    }

    public UserStringStream getUserStringStream() {
        return this.userStringStream;
    }

    public GuidStream getGuidStream() {
        return this.guidStream;
    }

    public BlobStream getBlobStream() {
        return this.blobStream;
    }

    public List<UnknownStream> getAdditionalStreams() {
        return this.additionalStreams;
    }

    public int getSizeOfMetadataStream() {
        return this.sizeOfMetadataStream;
    }

    public int getSizeOfStringsStream() {
        return this.sizeOfStringsStream;
    }

    public int getSizeOfUserStringStream() {
        return this.sizeOfUserStringStream;
    }

    public int getSizeOfGuidStream() {
        return this.sizeOfGuidStream;
    }

    public int getSizeOfBlobStream() {
        return this.sizeOfBlobStream;
    }

    public MetadataModel getMetaModel() {
        return this.metaModel;
    }

    public static FacileLogHandler getFacileLogHandler() {
        return facileLogHandler;
    }

    public Assembly getAssembly() {
        return this.assembly;
    }

    public DOSHeader getDosHeader() {
        return this.dosHeader;
    }

    public COFFPEHeader getCoffPeHeader() {
        return this.coffPeHeader;
    }

    public PEOptionalHeader getPeOptionalHeader() {
        return this.peOptionalHeader;
    }

    public PEDataDirectories getPeDataDirectories() {
        return this.peDataDirectories;
    }

    public PESectionHeader[] getPeSectionHeaders() {
        if (this.peSectionHeaders == null || this.peSectionHeaders.size() == 0) {
            return new PESectionHeader[0];
        }
        return this.peSectionHeaders.toArray(new PESectionHeader[this.peSectionHeaders.size()]);
    }

    public boolean isDebugDataAvailable() {
        return this.debugDataAvailable;
    }

    public int getPartialLoadingSizeInBytes() {
        return this.partialLoadingSizeInBytes;
    }

    public void setPartialLoadingSizeInBytes(int partialLoadingSizeInBytes) {
        this.partialLoadingSizeInBytes = partialLoadingSizeInBytes;
    }

    public boolean getHaltOnErrors() {
        return this.haltOnErrors;
    }

    public void setHaltOnErrors(boolean haltOnErrors) {
        this.haltOnErrors = haltOnErrors;
    }

    public boolean getHaltOnJniErrors() {
        return this.haltOnJniErrors;
    }

    public void setHaltOnJniErrors(boolean haltOnJniErrors) {
        this.haltOnJniErrors = haltOnJniErrors;
    }

    public List<Assembly> getReferenceAssemblies() {
        return this.referenceAssemblies;
    }

    public boolean addReferenceAssembly(Assembly referenceAssembly) {
        return this.referenceAssemblies.add(referenceAssembly);
    }

    public boolean removeReferenceAssembly(Assembly referenceAssembly) {
        return this.referenceAssemblies.remove(referenceAssembly);
    }

    public Map<String, Byte> getReferneceEnums() {
        return this.referneceEnums;
    }

    public boolean addReferneceEnum(String fullQualifiedTypeName, byte sizeInBytes) {
        if (!this.referneceEnums.containsKey(fullQualifiedTypeName)) {
            this.referneceEnums.put(fullQualifiedTypeName, sizeInBytes);
            return true;
        }
        return false;
    }

    public boolean removeReferneceEnum(String fullQualifiedTypeName) {
        return this.referneceEnums.remove(fullQualifiedTypeName) != null;
    }

    static {
        facileLogHandler = new FacileLogHandler();
        logger = Logger.getLogger(LOGGER_NAME);
        logger.addHandler(facileLogHandler);
        logger.setUseParentHandlers(false);
    }
}

