/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile;

import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class FacileLogHandler
extends Handler {
    private static final int CAPACITY = 1024;
    private StringBuffer logBuffer = new StringBuffer(1024);
    private boolean intermediate = false;
    private boolean isClosed = false;

    public FacileLogHandler() {
    }

    public FacileLogHandler(boolean intermediate) {
        this();
        this.intermediate = intermediate;
    }

    public void SetIntermediate(boolean intermediate) {
        this.intermediate = intermediate;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public void flush() {
        this.logBuffer = new StringBuffer(1024);
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isClosed) {
            String msg = record.getLevel().toString() + ": " + record.getMessage() + "\n";
            if (this.intermediate) {
                System.out.print(msg);
            }
            if (this.logBuffer.length() >= 1024) {
                this.flush();
            }
            this.logBuffer.append(msg);
        }
    }

    public String toString() {
        return this.logBuffer.toString();
    }
}

