/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile;

import at.pollaknet.api.facile.FacileReflector;
import at.pollaknet.api.facile.exception.CoffPeDataNotFoundException;
import at.pollaknet.api.facile.exception.DotNetContentNotFoundException;
import at.pollaknet.api.facile.exception.SizeMismatchException;
import at.pollaknet.api.facile.exception.UnexpectedHeaderDataException;
import at.pollaknet.api.facile.renderer.ILAsmRenderer;
import at.pollaknet.api.facile.symtab.symbols.scopes.Assembly;
import java.io.IOException;

public class Facile {
    public static void main(String[] args) {
        if (args.length < 1) {
            Facile.printUsageString();
            return;
        }
        boolean createIlOutput = false;
        boolean binaryCustomAttributes = false;
        boolean outputMetadataStream = false;
        boolean outputStringsStream = false;
        boolean outputBlobStream = false;
        boolean outputGuidStream = false;
        boolean outputUserStringStream = false;
        boolean verbose = false;
        boolean log = false;
        boolean assemblyOverview = false;
        String assemblyPath = null;
        String pdbPath = null;
        for (String arg : args) {
            if (arg.equals("--il")) {
                createIlOutput = true;
                continue;
            }
            if (arg.equals("--bca")) {
                binaryCustomAttributes = true;
                continue;
            }
            if (arg.equals("--info")) {
                assemblyOverview = true;
                continue;
            }
            if (arg.equals("--verbose")) {
                verbose = true;
                continue;
            }
            if (arg.equals("--log")) {
                log = true;
                continue;
            }
            if (arg.equals("--#~")) {
                outputStringsStream = true;
                continue;
            }
            if (arg.equals("--#Strings")) {
                outputStringsStream = true;
                continue;
            }
            if (arg.equals("--#Blob")) {
                outputBlobStream = true;
                continue;
            }
            if (arg.equals("--#GUID")) {
                outputGuidStream = true;
                continue;
            }
            if (arg.equals("--#US")) {
                outputUserStringStream = true;
                continue;
            }
            if (arg.endsWith(".exe") || arg.endsWith(".dll") || arg.endsWith(".netmodule") || arg.endsWith(".winmd") || arg.endsWith(".mcl")) {
                if (assemblyPath == null) {
                    assemblyPath = arg;
                    continue;
                }
                pdbPath = arg;
                continue;
            }
            if (!arg.endsWith(".pdb")) continue;
            pdbPath = arg;
        }
        if (assemblyPath == null) {
            System.out.println("Error: No assembly specified!");
            Facile.printUsageString();
            return;
        }
        System.out.println("Specified Assembly: " + assemblyPath);
        if (pdbPath != null) {
            System.out.println("Specified Program Debug Database: " + pdbPath);
        }
        System.out.println();
        System.out.println("Running Facile with the following parameter setup:");
        System.out.println("==================================================");
        if (verbose) {
            System.out.println("--verbose       : Verbose output");
        }
        if (log) {
            System.out.println("--log           : Print the log file at the end (all verbose messages)");
        }
        if (assemblyOverview) {
            System.out.println("--info          : Print assembly info (overview)");
        }
        if (createIlOutput) {
            System.out.println("--il            : Generating IL code in current working directory");
        }
        if (binaryCustomAttributes) {
            System.out.println("--bca           : Generating binary custom attributes in IL code");
        }
        if (outputMetadataStream) {
            System.out.println("--#~            : Output #~ (Metadata) Stream");
        }
        if (outputStringsStream) {
            System.out.println("--#Strings      : Output #Strings Stream");
        }
        if (outputBlobStream) {
            System.out.println("--#Blob         : Output #Blob Stream");
        }
        if (outputGuidStream) {
            System.out.println("--#GUID         : Output #GUID Stream");
        }
        if (outputUserStringStream) {
            System.out.println("--#US           : Output #US (UserString) Stream");
        }
        System.out.println();
        if (verbose) {
            FacileReflector.getFacileLogHandler().SetIntermediate(true);
        }
        FacileReflector facileReflector = null;
        try {
            facileReflector = pdbPath == null ? Facile.load(assemblyPath) : Facile.load(assemblyPath, pdbPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (outputMetadataStream) {
            System.out.println(facileReflector.getMetadataStream());
        }
        if (outputStringsStream) {
            System.out.println(facileReflector.getStringsStream());
        }
        if (outputBlobStream) {
            System.out.println(facileReflector.getBlobStream());
        }
        if (outputGuidStream) {
            System.out.println(facileReflector.getGuidStream());
        }
        if (outputUserStringStream) {
            System.out.println(facileReflector.getUserStringStream());
        }
        Assembly assembly = null;
        try {
            assembly = facileReflector.loadAssembly();
            if (assembly != null) {
                if (assemblyOverview) {
                    System.out.println(assembly.toExtendedString());
                }
                if (createIlOutput) {
                    ILAsmRenderer renderer = new ILAsmRenderer(facileReflector, binaryCustomAttributes);
                    renderer.renderSourceFilesToDirectory(assembly, System.getProperty("user.dir"));
                    System.out.println("Generated decompiled files in: " + System.getProperty("user.dir"));
                }
            } else if (assemblyOverview) {
                System.out.println("File contains only resources.");
            }
        }
        catch (DotNetContentNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (log) {
            System.out.println("Facile Log:");
            System.out.println(FacileReflector.getFacileLogHandler());
        }
        System.out.println("Done.");
    }

    private static void printUsageString() {
        System.out.println("usage:  java Facile ASSEMBLY [OPTIONAL_PDB] [OPTIONS]");
        System.out.println("=====================================================");
        System.out.println("The first specified file will be treated as the assembly,");
        System.out.println("the second as the PDB (program debug database).");
        System.out.println();
        System.out.println("ASSEMBLY:");
        System.out.println("  The .Net assembly to analyze.");
        System.out.println();
        System.out.println("OPTIONAL_PDB:");
        System.out.println("  The program debug database, or the assembly it self");
        System.out.println("  again, if it has embedded debug information.");
        System.out.println();
        System.out.println("OPTIONS:");
        System.out.println("  --verbose   : More intermediate output");
        System.out.println("  --log       : Print the whole log file at the end");
        System.out.println("                (all messages from the verbose mode)");
        System.out.println("  --info      : Print assembly info (summary)");
        System.out.println("  --il        : Generate IL code in current working directory");
        System.out.println("  --bca       : Generate binary custom attributes in IL code");
        System.out.println("  --#~        : Output #~ (Metadata) Stream");
        System.out.println("  --#Strings  : Output #Strings Stream");
        System.out.println("  --#Blob     : Output #Blob Stream");
        System.out.println("  --#GUID     : Output #GUID Stream");
        System.out.println("  --#US       : Output #US (UserString) Stream");
    }

    public static Assembly loadAssembly(String pathToAssembly, boolean loadByteCode) throws CoffPeDataNotFoundException, UnexpectedHeaderDataException, SizeMismatchException, IOException {
        FacileReflector reflector = new FacileReflector(pathToAssembly);
        return reflector.loadAssembly(loadByteCode);
    }

    public static Assembly loadAssembly(String pathToAssembly) throws CoffPeDataNotFoundException, UnexpectedHeaderDataException, SizeMismatchException, IOException {
        return Facile.loadAssembly(pathToAssembly, true);
    }

    public static Assembly loadAssembly(String pathToAssembly, String pathToPdb) throws CoffPeDataNotFoundException, UnexpectedHeaderDataException, SizeMismatchException, IOException {
        FacileReflector reflector = new FacileReflector(pathToAssembly, pathToPdb);
        return reflector.loadAssembly();
    }

    public static Assembly loadAssembly(byte[] buffer) throws CoffPeDataNotFoundException, UnexpectedHeaderDataException, SizeMismatchException {
        FacileReflector reflector = new FacileReflector(buffer);
        return reflector.loadAssembly();
    }

    public static FacileReflector load(String pathToAssembly) throws CoffPeDataNotFoundException, UnexpectedHeaderDataException, SizeMismatchException, IOException {
        FacileReflector reflector = new FacileReflector(pathToAssembly);
        reflector.loadAssembly();
        return reflector;
    }

    public static FacileReflector load(String pathToAssembly, String pathToPdb) throws CoffPeDataNotFoundException, UnexpectedHeaderDataException, SizeMismatchException, IOException {
        FacileReflector reflector = new FacileReflector(pathToAssembly, pathToPdb);
        reflector.loadAssembly();
        return reflector;
    }

    public static FacileReflector load(byte[] buffer) throws CoffPeDataNotFoundException, UnexpectedHeaderDataException, SizeMismatchException {
        FacileReflector reflector = new FacileReflector(buffer);
        reflector.loadAssembly();
        return reflector;
    }

    public static FacileReflector reflect(String pathToAssembly) throws CoffPeDataNotFoundException, UnexpectedHeaderDataException, SizeMismatchException, IOException {
        return new FacileReflector(pathToAssembly);
    }

    public static FacileReflector reflect(String pathToAssembly, String pathToPdb) throws CoffPeDataNotFoundException, UnexpectedHeaderDataException, SizeMismatchException, IOException {
        return new FacileReflector(pathToAssembly, pathToPdb);
    }

    public static FacileReflector reflect(byte[] buffer) throws CoffPeDataNotFoundException, UnexpectedHeaderDataException, SizeMismatchException {
        return new FacileReflector(buffer);
    }
}

